import os
import shutil


def check_folder(*folders):
    for f in folders:
        if not os.path.exists(f):
            os.makedirs(f)


def clear_folder(folder):
    for f in os.listdir(folder):
        filename = os.path.join(folder, f)
        if os.path.isfile(filename):
            os.remove(filename)
        else:
            shutil.rmtree(filename)


def has_subfolder(folder):
    for f in os.listdir(folder):
        if os.path.isdir(os.path.join(folder, f)):
            return True
    return False


def has_subfile(folder):
    for f in os.listdir(folder):
        if os.path.isfile(os.path.join(folder, f)):
            return True
    return False


def file_num(folder):
    cnt = 0
    for f in os.listdir(folder):
        if os.path.isfile(os.path.join(folder, f)):
            cnt += 1
    return cnt
