import cv2


def isinpolygon(point, vertex_list: list, contain_boundary=True):
    # 检测点是否位于区域外接矩形内
    x_axis, y_axis = zip(*vertex_list)
    min_x, max_x = min(x_axis), max(x_axis)
    min_y, max_y = min(y_axis), max(y_axis)
    point_x, point_y = point
    if contain_boundary:
        result = (min_x <= point_x <= max_x) & (min_y <= point_y <= max_y)
    else:
        result = (min_x < point_x < max_x) & (min_y < point_y < max_y)
    return result


def isintersect(poi, spoi, epoi):
    point_x, point_y = poi
    spoi_x, spoi_y = spoi
    epoi_x, epoi_y = epoi
    if poi == spoi:
        return None
    if spoi_y == epoi_y:  # 排除与射线平行、重合，线段首尾端点重合的情况
        return False
    if spoi_y > point_y and epoi_y > point_y:  # 线段在射线上边
        return False
    if spoi_y < point_y and epoi_y < point_y:  # 线段在射线下边
        return False
    if spoi_y == point_y and epoi_y > point_y:  # 交点为下端点，对应spoint
        return False
    if epoi_y == point_y and spoi_y > point_y:  # 交点为下端点，对应epoint
        return False
    if spoi_x < point_x and epoi_x < point_x:  # 线段在射线左边
        return False
    # 求交点
    xseg = epoi_x - (epoi_x - spoi_x) * (epoi_y - point_y) / (epoi_y - spoi_y)
    if xseg == point_x:
        return None
    if xseg < point_x:  # 交点在射线起点的左侧
        return False
    return True  # 排除上述情况之后


def is_contain(poi, vertex_list, contain_boundary=True):
    if not isinpolygon(poi, vertex_list, contain_boundary):
        return False
    sinsc = 0
    for spoi, epoi in zip(vertex_list[:-1], vertex_list[1::]):
        intersect = isintersect(poi, spoi, epoi)
        if intersect is None:
            return (False, True)[contain_boundary]  # 返回是none，则根据函数输入参数判断结果
        elif intersect:
            sinsc += 1
    return sinsc % 2 == 1


def draw_zone(img, vertex_list, r, g, b):  # 一次画一个区域
    length = len(vertex_list)
    i = 0
    while i <= length - 2:
        spoi_x, spoi_y = vertex_list[i]
        epoi_x, epoi_y = vertex_list[i + 1]
        cv2.line(img, (spoi_x, spoi_y), (epoi_x, epoi_y), (r, g, b), 2, 4)
        i = i + 1

    return img
